# 2021-08-25 Triage Log

A few regressions but largely an improvement this week, mostly due to the
upgrade to LLVM 13.

Triage done by **@simulacrum**.
Revision range: [aa8f27bf4d980023a8b245ceb25a490a18041eb2..33fdb797f59421c7bbecaa4588ed5d7a31a9494a](https://perf.rust-lang.org/?start=aa8f27bf4d980023a8b245ceb25a490a18041eb2&end=33fdb797f59421c7bbecaa4588ed5d7a31a9494a&absolute=false&stat=instructions%3Au)

2 Regressions, 1 Improvements, 2 Mixed; 0 of them in rollups

#### Regressions

Update the backtrace crate in libstd [#88151](https://github.com/rust-lang/rust/issues/88151)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=2451f42c1deb9379d5e8e5fa86b0bf857ae048ec&end=7960030d6915a771f5ab72c3897a7ed50c3ed4bd&stat=instructions:u) (up to 2.6% on `incr-patched: u8 3072` builds of `issue-46449`)
- Standard regression from an increase in std/core size due to added items.

Add fast path for Path::cmp that skips over long shared prefixes [#86898](https://github.com/rust-lang/rust/issues/86898)
- Small improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=7611fe438dae91084d17022e705bf64374d5ba4b&end=bcfd3f7e88084850f87b8e34b4dcb9fceb872d00&stat=instructions:u) (up to -0.3% on `incr-unchanged` builds of `helloworld`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=7611fe438dae91084d17022e705bf64374d5ba4b&end=bcfd3f7e88084850f87b8e34b4dcb9fceb872d00&stat=instructions:u) (up to 1.2% on `incr-patched: println` builds of `ripgrep`)
- Largely in -doc builds, seems to be a small but real regression.

#### Improvements

Reenable RemoveZsts [#88176](https://github.com/rust-lang/rust/issues/88176)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=d77dcbc5993a06d200fc1fa5554778bc8fb67d36&end=914a1e2c517dfbaa23a4ec4a3eebefb3e2c253c2&stat=instructions:u) (up to -4.2% on `incr-unchanged` builds of `deeply-nested-async`)


#### Mixed

Revert "Auto merge of #83417 - erikdesjardins:enableremovezsts, r=oli-obk" [#88056](https://github.com/rust-lang/rust/issues/88056)
- Small improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=aa8f27bf4d980023a8b245ceb25a490a18041eb2&end=806b3995b8f622d5de10afcc11c10a028a7b876a&stat=instructions:u) (up to -0.5% on `incr-patched: println` builds of `cargo`)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=aa8f27bf4d980023a8b245ceb25a490a18041eb2&end=806b3995b8f622d5de10afcc11c10a028a7b876a&stat=instructions:u) (up to 4.5% on `incr-unchanged` builds of `deeply-nested-async`)
- Regression is canceled out by the later #88176 (see improvements above).


Upgrade to LLVM 13 [#87570](https://github.com/rust-lang/rust/issues/87570)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=e7f7fe462a54b1caeb804a974cd43ba9fd7bee5c&end=db002a06ae9154a35d410550bc5132df883d7baa&stat=instructions:u) (up to -10.4% on `incr-unchanged` builds of `helloworld`)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=e7f7fe462a54b1caeb804a974cd43ba9fd7bee5c&end=db002a06ae9154a35d410550bc5132df883d7baa&stat=instructions:u) (up to 9.6% on `full` builds of `match-stress-enum`)
- Overall an improvement, regressions are significantly more limited to just a
  few cases compared to the improvements seen across the board.

#### Untriaged Pull Requests

- [#87815 encode `generics_of` for fields and ty params](https://github.com/rust-lang/rust/pull/87815)
- [#87781 Remove box syntax from compiler and tools](https://github.com/rust-lang/rust/pull/87781)
- [#87640 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/87640)
- [#87587 Various refactorings of the TAIT infrastructure](https://github.com/rust-lang/rust/pull/87587)
- [#87570 Upgrade to LLVM 13](https://github.com/rust-lang/rust/pull/87570)
- [#87244 Better diagnostics with mismatched types due to implicit static lifetime](https://github.com/rust-lang/rust/pull/87244)
- [#86777 Include terminators in instance size estimate](https://github.com/rust-lang/rust/pull/86777)
- [#86698 Move OnDiskCache to rustc_query_impl.](https://github.com/rust-lang/rust/pull/86698)
- [#86588 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/86588)
- [#86034 Change entry point to 🛡️ against 💥 💥-payloads](https://github.com/rust-lang/rust/pull/86034)
- [#84560 Inline Iterator as IntoIterator.](https://github.com/rust-lang/rust/pull/84560)
- [#80357 Introduce `hir::ExprKind::Let` - Take 2](https://github.com/rust-lang/rust/pull/80357)
