% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build-sql.R
\name{build_sql}
\alias{build_sql}
\title{Build a SQL string.}
\usage{
build_sql(..., .env = parent.frame(), con = sql_current_con())
}
\arguments{
\item{...}{input to convert to SQL. Use \code{\link[=sql]{sql()}} to preserve
user input as is (dangerous), and \code{\link[=ident]{ident()}} to label user
input as sql identifiers (safe)}

\item{.env}{the environment in which to evaluate the arguments. Should not
be needed in typical use.}

\item{con}{database connection; used to select correct quoting characters.}
}
\description{
This is a convenience function that should prevent sql injection attacks
(which in the context of dplyr are most likely to be accidental not
deliberate) by automatically escaping all expressions in the input, while
treating bare strings as sql. This is unlikely to prevent any serious
attack, but should make it unlikely that you produce invalid sql.
}
\details{
This function should be used only when generating \code{SELECT} clauses,
other high level queries, or for other syntax that has no R equivalent.
For individual function translations, prefer \code{\link[=sql_expr]{sql_expr()}}.
}
\examples{
con <- simulate_dbi()
build_sql("SELECT * FROM TABLE", con = con)
x <- "TABLE"
build_sql("SELECT * FROM ", x, con = con)
build_sql("SELECT * FROM ", ident(x), con = con)
build_sql("SELECT * FROM ", sql(x), con = con)

# http://xkcd.com/327/
name <- "Robert'); DROP TABLE Students;--"
build_sql("INSERT INTO Students (Name) VALUES (", name, ")", con = con)
}
\keyword{internal}
