# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.recoveryservicessiterecovery import SiteRecoveryManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSiteRecoveryManagementReplicationMigrationItemsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SiteRecoveryManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_migration_items_list_by_replication_protection_containers(self, resource_group):
        response = self.client.replication_migration_items.list_by_replication_protection_containers(
            fabric_name="str",
            protection_container_name="str",
            api_version="2025-01-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_migration_items_get(self, resource_group):
        response = self.client.replication_migration_items.get(
            fabric_name="str",
            protection_container_name="str",
            migration_item_name="str",
            api_version="2025-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_migration_items_begin_create(self, resource_group):
        response = self.client.replication_migration_items.begin_create(
            fabric_name="str",
            protection_container_name="str",
            migration_item_name="str",
            input={
                "properties": {"policyId": "str", "providerSpecificDetails": "enable_migration_provider_specific_input"}
            },
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_migration_items_begin_delete(self, resource_group):
        response = self.client.replication_migration_items.begin_delete(
            fabric_name="str",
            protection_container_name="str",
            migration_item_name="str",
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_migration_items_begin_update(self, resource_group):
        response = self.client.replication_migration_items.begin_update(
            fabric_name="str",
            protection_container_name="str",
            migration_item_name="str",
            input={"properties": {"providerSpecificDetails": "update_migration_item_provider_specific_input"}},
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_migration_items_begin_migrate(self, resource_group):
        response = self.client.replication_migration_items.begin_migrate(
            fabric_name="str",
            protection_container_name="str",
            migration_item_name="str",
            migrate_input={"properties": {"providerSpecificDetails": "migrate_provider_specific_input"}},
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_migration_items_begin_pause_replication(self, resource_group):
        response = self.client.replication_migration_items.begin_pause_replication(
            fabric_name="str",
            protection_container_name="str",
            migration_item_name="str",
            pause_replication_input={"properties": {"instanceType": "str"}},
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_migration_items_begin_resume_replication(self, resource_group):
        response = self.client.replication_migration_items.begin_resume_replication(
            fabric_name="str",
            protection_container_name="str",
            migration_item_name="str",
            resume_replication_input={
                "properties": {"providerSpecificDetails": "resume_replication_provider_specific_input"}
            },
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_migration_items_begin_resync(self, resource_group):
        response = self.client.replication_migration_items.begin_resync(
            fabric_name="str",
            protection_container_name="str",
            migration_item_name="str",
            input={"properties": {"providerSpecificDetails": "resync_provider_specific_input"}},
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_migration_items_begin_test_migrate(self, resource_group):
        response = self.client.replication_migration_items.begin_test_migrate(
            fabric_name="str",
            protection_container_name="str",
            migration_item_name="str",
            test_migrate_input={"properties": {"providerSpecificDetails": "test_migrate_provider_specific_input"}},
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_migration_items_begin_test_migrate_cleanup(self, resource_group):
        response = self.client.replication_migration_items.begin_test_migrate_cleanup(
            fabric_name="str",
            protection_container_name="str",
            migration_item_name="str",
            test_migrate_cleanup_input={"properties": {"comments": "str"}},
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_migration_items_list(self, resource_group):
        response = self.client.replication_migration_items.list(
            api_version="2025-01-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
