#!/usr/bin/env python3
# Copyright (C) 2025 The Android Open Source Project
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from python.generators.diff_tests.testing import DataPath
from python.generators.diff_tests.testing import Csv
from python.generators.diff_tests.testing import DiffTestBlueprint
from python.generators.diff_tests.testing import TestSuite


class AndroidBitmaps(TestSuite):

  def test_android_bitmap_counters_per_process(self):
    return DiffTestBlueprint(
        trace=DataPath('sysui_qsmedia_microbenchmark.pb'),
        query="""
        INCLUDE PERFETTO MODULE android.bitmaps;

        SELECT
          process_name,
          ts,
          dur,
          bitmap_memory,
          bitmap_count
        FROM android_bitmap_counters_per_process
        WHERE process_name = 'com.android.systemui';
        """,
        out=Csv("""
        "process_name","ts","dur","bitmap_memory","bitmap_count"
        "com.android.systemui",606922346935,984049,773876.000000,18.000000
        "com.android.systemui",606923330984,5249,1133876.000000,18.000000
        "com.android.systemui",606923336233,18882813,1133876.000000,19.000000
        "com.android.systemui",606942219046,1627,1162100.000000,19.000000
        "com.android.systemui",606942220673,15951,1162100.000000,20.000000
        "com.android.systemui",606942236624,1139,1198964.000000,20.000000
        "com.android.systemui",606942237763,232341,1198964.000000,21.000000
        "com.android.systemui",606942470104,1139,1162100.000000,21.000000
        "com.android.systemui",606942471243,1161174,1162100.000000,20.000000
        "com.android.systemui",606943632417,3906,1190324.000000,20.000000
        "com.android.systemui",606943636323,34261,1190324.000000,21.000000
        "com.android.systemui",606943670584,3336,1227188.000000,21.000000
        "com.android.systemui",606943673920,580770,1227188.000000,22.000000
        "com.android.systemui",606944254690,2971,1190324.000000,22.000000
        "com.android.systemui",606944257661,28646077,1190324.000000,21.000000
        "com.android.systemui",606972903738,1546,1198004.000000,21.000000
        "com.android.systemui",606972905284,414633,1198004.000000,22.000000
        "com.android.systemui",606973319917,1546,1205684.000000,22.000000
        "com.android.systemui",606973321463,335693,1205684.000000,23.000000
        "com.android.systemui",606973657156,1587,1213364.000000,23.000000
        "com.android.systemui",606973658743,28796021,1213364.000000,24.000000
        "com.android.systemui",607002454764,2115,1573364.000000,24.000000
        "com.android.systemui",607002456879,5690471,1573364.000000,25.000000
        "com.android.systemui",607008147350,7243,1622648.000000,25.000000
        "com.android.systemui",607008154593,70557861,1622648.000000,26.000000
        "com.android.systemui",607078712454,1750,1573364.000000,26.000000
        "com.android.systemui",607078714204,7490315,1573364.000000,25.000000
        "com.android.systemui",607086204519,1750,1601588.000000,25.000000
        "com.android.systemui",607086206269,24251,1601588.000000,26.000000
        "com.android.systemui",607086230520,1221,1638452.000000,26.000000
        "com.android.systemui",607086231741,232829,1638452.000000,27.000000
        "com.android.systemui",607086464570,1099,1601588.000000,27.000000
        "com.android.systemui",607086465669,6377807,1601588.000000,26.000000
        "com.android.systemui",607092843476,1668,1638708.000000,26.000000
        "com.android.systemui",607092845144,120036,1638708.000000,27.000000
        "com.android.systemui",607092965180,1262,1610484.000000,27.000000
        "com.android.systemui",607092966442,148265991,1610484.000000,26.000000
        "com.android.systemui",607241232433,2319,1614580.000000,26.000000
        "com.android.systemui",607241234752,694621,1614580.000000,27.000000
        "com.android.systemui",607241929373,1994,1709836.000000,27.000000
        "com.android.systemui",607241931367,196655,1709836.000000,28.000000
        "com.android.systemui",607242128022,936,1725212.000000,28.000000
        "com.android.systemui",607242128958,125814,1725212.000000,29.000000
        "com.android.systemui",607242254772,976,1729308.000000,29.000000
        "com.android.systemui",607242255748,77515,1729308.000000,30.000000
        "com.android.systemui",607242333263,977,1731156.000000,30.000000
        "com.android.systemui",607242334240,48706,1731156.000000,31.000000
        "com.android.systemui",607242382946,936,1735252.000000,31.000000
        "com.android.systemui",607242383882,17893269,1735252.000000,32.000000
        "com.android.systemui",607260277151,2401,1746488.000000,32.000000
        "com.android.systemui",607260279552,592367,1746488.000000,33.000000
        "com.android.systemui",607260871919,1831,1757724.000000,33.000000
        "com.android.systemui",607260873750,185547,1757724.000000,34.000000
        "com.android.systemui",607261059297,1749,1768960.000000,34.000000
        "com.android.systemui",607261061046,229859,1768960.000000,35.000000
        "com.android.systemui",607261290905,1709,1780196.000000,35.000000
        "com.android.systemui",607261292614,88376017,1780196.000000,36.000000
        "com.android.systemui",607349668631,2075,1791432.000000,36.000000
        "com.android.systemui",607349670706,354736,1791432.000000,37.000000
        "com.android.systemui",607350025442,814,1802668.000000,37.000000
        "com.android.systemui",607350026256,87769,1802668.000000,38.000000
        "com.android.systemui",607350114025,732,1813904.000000,38.000000
        "com.android.systemui",607350114757,53274984,1813904.000000,39.000000
        "com.android.systemui",607403389741,1058,1820628.000000,39.000000
        "com.android.systemui",607403390799,190145,1820628.000000,40.000000
        "com.android.systemui",607403580944,651,1831864.000000,40.000000
        "com.android.systemui",607403581595,1689715821,1831864.000000,41.000000
        "com.android.systemui",609093297416,3011,1834673.000000,41.000000
        "com.android.systemui",609093300427,614787,1834673.000000,42.000000
        "com.android.systemui",609093915214,2604,1837482.000000,42.000000
        "com.android.systemui",609093917818,2434489,1837482.000000,43.000000
        "com.android.systemui",609096352307,1750,1848718.000000,43.000000
        "com.android.systemui",609096354057,4565470,1848718.000000,44.000000
        "com.android.systemui",609100919527,4394,1859954.000000,44.000000
        "com.android.systemui",609100923921,630412,1859954.000000,45.000000
        "com.android.systemui",609101554333,2157,1871190.000000,45.000000
        "com.android.systemui",609101556490,89599,1871190.000000,46.000000
        "com.android.systemui",609101646089,1343,1882426.000000,46.000000
        "com.android.systemui",609101647432,133545,1882426.000000,47.000000
        "com.android.systemui",609101780977,1750,1893662.000000,47.000000
        "com.android.systemui",609101782727,235229,1893662.000000,48.000000
        "com.android.systemui",609102017956,1628,1904898.000000,48.000000
        "com.android.systemui",609102019584,74951,1904898.000000,49.000000
        "com.android.systemui",609102094535,1424,1916134.000000,49.000000
        "com.android.systemui",609102095959,106446,1916134.000000,50.000000
        "com.android.systemui",609102202405,1464,1927370.000000,50.000000
        "com.android.systemui",609102203869,547838217,1927370.000000,51.000000
        "com.android.systemui",609650042086,1180,1930898.000000,51.000000
        "com.android.systemui",609650043266,144572,1930898.000000,52.000000
        "com.android.systemui",609650187838,854,1934426.000000,52.000000
        "com.android.systemui",609650188692,44678,1934426.000000,53.000000
        "com.android.systemui",609650233370,854,1937954.000000,53.000000
        "com.android.systemui",609650234224,18577963,1937954.000000,54.000000
        "com.android.systemui",609668812187,1790,1948770.000000,54.000000
        "com.android.systemui",609668813977,54366048,1948770.000000,55.000000
        "com.android.systemui",609723180025,1709,1960006.000000,55.000000
        "com.android.systemui",609723181734,164144,1960006.000000,56.000000
        "com.android.systemui",609723345878,1628,1971242.000000,56.000000
        "com.android.systemui",609723347506,69092,1971242.000000,57.000000
        "com.android.systemui",609723416598,732,1982478.000000,57.000000
        "com.android.systemui",609723417330,82520,1982478.000000,58.000000
        "com.android.systemui",609723499850,773,1993714.000000,58.000000
        "com.android.systemui",609723500623,36539,1993714.000000,59.000000
        "com.android.systemui",609723537162,773,2004950.000000,59.000000
        "com.android.systemui",609723537935,87688,2004950.000000,60.000000
        "com.android.systemui",609723625623,773,2016186.000000,60.000000
        "com.android.systemui",609723626396,68481,2016186.000000,61.000000
        "com.android.systemui",609723694877,773,2027422.000000,61.000000
        "com.android.systemui",609723695650,6692203617,2027422.000000,62.000000
        "com.android.systemui",616415899267,1831,2038658.000000,62.000000
        "com.android.systemui",616415901098,2967911826,2038658.000000,63.000000
        """))

  def test_android_bitmap_count(self):
    return DiffTestBlueprint(
        trace=DataPath('sysui_qsmedia_microbenchmark.pb'),
        query="""
        INCLUDE PERFETTO MODULE android.bitmaps;
        SELECT id, upid, ts, dur, track_id, value
        FROM android_bitmap_count
        """,
        out=Csv("""
        "id","upid","ts","dur","track_id","value"
        4947,3,606922346935,989298,2817,18.000000
        4955,3,606923336233,18884440,2817,19.000000
        5236,3,606942220673,17090,2817,20.000000
        5238,3,606942237763,233480,2817,21.000000
        5244,3,606942471243,1165080,2817,20.000000
        5290,3,606943636323,37597,2817,21.000000
        5293,3,606943673920,583741,2817,22.000000
        5322,3,606944257661,28647623,2817,21.000000
        5742,3,606972905284,416179,2817,22.000000
        5751,3,606973321463,337280,2817,23.000000
        5757,3,606973658743,28798136,2817,24.000000
        6100,3,607002456879,5697714,2817,25.000000
        6204,3,607008154593,70559611,2817,26.000000
        6753,3,607078714204,7492065,2817,25.000000
        6862,3,607086206269,25472,2817,26.000000
        6864,3,607086231741,233928,2817,27.000000
        6869,3,607086465669,6379475,2817,26.000000
        6999,3,607092845144,121298,2817,27.000000
        7003,3,607092966442,148268310,2817,26.000000
        8773,3,607241234752,696615,2817,27.000000
        8786,3,607241931367,197591,2817,28.000000
        8793,3,607242128958,126790,2817,29.000000
        8800,3,607242255748,78492,2817,30.000000
        8802,3,607242334240,49642,2817,31.000000
        8804,3,607242383882,17895670,2817,32.000000
        9269,3,607260279552,594198,2817,33.000000
        9284,3,607260873750,187296,2817,34.000000
        9289,3,607261061046,231568,2817,35.000000
        9291,3,607261292614,88378092,2817,36.000000
        13190,3,607349670706,355550,2817,37.000000
        13211,3,607350026256,88501,2817,38.000000
        13214,3,607350114757,53276042,2817,39.000000
        16337,3,607403390799,190796,2817,40.000000
        16344,3,607403581595,1689718832,2817,41.000000
        45502,3,609093300427,617391,2817,42.000000
        45505,3,609093917818,2436239,2817,43.000000
        45589,3,609096354057,4569864,2817,44.000000
        45743,3,609100923921,632569,2817,45.000000
        45790,3,609101556490,90942,2817,46.000000
        45794,3,609101647432,135295,2817,47.000000
        45802,3,609101782727,236857,2817,48.000000
        45811,3,609102019584,76375,2817,49.000000
        45817,3,609102095959,107910,2817,50.000000
        45819,3,609102203869,547839397,2817,51.000000
        67716,3,609650043266,145426,2817,52.000000
        67727,3,609650188692,45532,2817,53.000000
        67729,3,609650234224,18579753,2817,54.000000
        68341,3,609668813977,54367757,2817,55.000000
        70999,3,609723181734,165772,2817,56.000000
        71018,3,609723347506,69824,2817,57.000000
        71023,3,609723417330,83293,2817,58.000000
        71036,3,609723500623,37312,2817,59.000000
        71040,3,609723537935,88461,2817,60.000000
        71053,3,609723626396,69254,2817,61.000000
        71057,3,609723695650,6692205448,2817,62.000000
        135837,3,616415901098,2967911826,2817,63.000000
        """))

  def test_android_bitmap_memory(self):
    return DiffTestBlueprint(
        trace=DataPath('sysui_qsmedia_microbenchmark.pb'),
        query="""
        INCLUDE PERFETTO MODULE android.bitmaps;
        SELECT id, upid, ts, dur, track_id, value
        FROM android_bitmap_memory
        """,
        out=Csv("""
        "id","upid","ts","dur","track_id","value"
        4946,3,606922341035,989949,2816,773876.000000
        4954,3,606923330984,18888062,2816,1133876.000000
        5235,3,606942219046,17578,2816,1162100.000000
        5237,3,606942236624,233480,2816,1198964.000000
        5243,3,606942470104,1162313,2816,1162100.000000
        5289,3,606943632417,38167,2816,1190324.000000
        5292,3,606943670584,584106,2816,1227188.000000
        5321,3,606944254690,28649048,2816,1190324.000000
        5741,3,606972903738,416179,2816,1198004.000000
        5750,3,606973319917,337239,2816,1205684.000000
        5756,3,606973657156,28797608,2816,1213364.000000
        6099,3,607002454764,5692586,2816,1573364.000000
        6202,3,607008147350,70565104,2816,1622648.000000
        6752,3,607078712454,7492065,2816,1573364.000000
        6861,3,607086204519,26001,2816,1601588.000000
        6863,3,607086230520,234050,2816,1638452.000000
        6868,3,607086464570,6378906,2816,1601588.000000
        6998,3,607092843476,121704,2816,1638708.000000
        7002,3,607092965180,148267253,2816,1610484.000000
        8772,3,607241232433,696940,2816,1614580.000000
        8785,3,607241929373,198649,2816,1709836.000000
        8792,3,607242128022,126750,2816,1725212.000000
        8799,3,607242254772,78491,2816,1729308.000000
        8801,3,607242333263,49683,2816,1731156.000000
        8803,3,607242382946,17894205,2816,1735252.000000
        9268,3,607260277151,594768,2816,1746488.000000
        9283,3,607260871919,187378,2816,1757724.000000
        9288,3,607261059297,231608,2816,1768960.000000
        9290,3,607261290905,88377726,2816,1780196.000000
        13189,3,607349668631,356811,2816,1791432.000000
        13210,3,607350025442,88583,2816,1802668.000000
        13213,3,607350114025,53275716,2816,1813904.000000
        16336,3,607403389741,191203,2816,1820628.000000
        16343,3,607403580944,1689716472,2816,1831864.000000
        45501,3,609093297416,617798,2816,1834673.000000
        45504,3,609093915214,2437093,2816,1837482.000000
        45588,3,609096352307,4567220,2816,1848718.000000
        45742,3,609100919527,634806,2816,1859954.000000
        45789,3,609101554333,91756,2816,1871190.000000
        45793,3,609101646089,134888,2816,1882426.000000
        45801,3,609101780977,236979,2816,1893662.000000
        45810,3,609102017956,76579,2816,1904898.000000
        45816,3,609102094535,107870,2816,1916134.000000
        45818,3,609102202405,547839681,2816,1927370.000000
        67715,3,609650042086,145752,2816,1930898.000000
        67726,3,609650187838,45532,2816,1934426.000000
        67728,3,609650233370,18578817,2816,1937954.000000
        68340,3,609668812187,54367838,2816,1948770.000000
        70998,3,609723180025,165853,2816,1960006.000000
        71017,3,609723345878,70720,2816,1971242.000000
        71022,3,609723416598,83252,2816,1982478.000000
        71035,3,609723499850,37312,2816,1993714.000000
        71039,3,609723537162,88461,2816,2004950.000000
        71052,3,609723625623,69254,2816,2016186.000000
        71056,3,609723694877,6692204390,2816,2027422.000000
        135836,3,616415899267,2967913657,2816,2038658.000000
        """))
