ITK Release 5.0 Alpha 2
=======================

Major improvements in ITK 5.0 include a switch to C++11 language standard, improved performance, and cleanup of legacy code. More information about the C++11 transition, spearheaded by Hans Johnson, can be read in the [ITK 5.0 Alpha 1 announcement](https://discourse.itk.org/t/itk-5-0-alpha-1-modern-c/843).

ITK 5.0 Alpha 2 emphasizes performance improvements: 1) A refactored multithreading infrastructure, 2) in ITK 5, a thread pool is available by default, 3) an Intel Threading Building Blocks (TBB) threading backend with dynamic region splitting, 4) improved image iterator performance, 5) simple APIs to execute functions in parallel, 6) simple construction of unary and binary generator image filters filters, and 7) new, experimental C++11 range classes for iteration in range-based for loops.

1. There are now two multi-threaded "GenerateData" method signatures. The classic one, *ThreadedGenerateData*, is kept when a filter needs to know in advance the number of pieces into which the requested region will be split. This information was previously used by some filters to allocate intermediate, thread-local data. The new dynamic signature, *DynamicThreadedGenerateData*, allows the region to be split dynamically in response to data content and multi-processor load to achieve load balancing. Presently, only the TBB backend performs dynamic splitting. More information can be found in the Multi-Threading section of in The [ITK Software Guide](https://itk.org/ItkSoftwareGuide.pdf). Instructions that describe changes required to leverage dynamic parallelism in external filters can be found in the [migration guide](https://github.com/InsightSoftwareConsortium/ITK/blob/master/Documentation/ITK5MigrationGuide.md#multithreading-refactored). Most existing ITK-based codes will build with minimal to no modifications required.

2. An *itk::PoolMultiThreader* is the default in ITK 5, which provides a thread pool for platform native threads. The *itk::PlatformMultiThreader* is also available, which behaves like the previous *itk::MultiThreader* class.

3. Our multi-threading refactoring enables better load balancing for filters with variable per-pixel computation cost. As [TBB](https://www.threadingbuildingblocks.org/) is one of the best open source libraries for load-balanced threading, it was an easy choice. The *itk::TBBMultiThreader* can be enabled by setting `Module_ITKTBB` to `ON` in ITK's CMake configuration.

4. Most methods in neighborhood iterators were virtual, but this was a rarely-used feature. That virtualization is now a [configure-time](https://github.com/InsightSoftwareConsortium/ITK/blob/7a7d88b85f258c3162001ccfa4e5a89540b4c411/Modules/Core/Common/include/itkMacro.h#L1276-L1288) parameter, and it is off by default. This significantly improves performance of filters which utilize neighborhood iterators. More information can be found in the Discourse [discussion](https://discourse.itk.org/t/removal-of-virtual-keywords-from-constneighborhooditerator/814/).

5. A [ParallelizeImageRegion](https://github.com/InsightSoftwareConsortium/ITK/blob/9382f7bdd89f08a1122d57f8144702ac9341caf3/Modules/Core/Common/include/itkMultiThreaderBase.h#L185) method allows multi-threaded processing without writing a full-blown filter class. As evident in [this example](https://itk.org/ITKExamples/src/Core/Common/FilterAndParallelizeImageRegion/Documentation.html), multiple parallelized operations of arbitrary complexity can now be concisely specified and executed with [C++11 lamda](https://en.cppreference.com/w/cpp/language/lambda)'s or [std::function](https://en.cppreference.com/w/cpp/utility/functional/function)'s.

6. The new [itk::UnaryGeneratorImageFilter](https://docs.itk.org/projects/doxygen/en/stable/classitk_1_1UnaryGeneratorImageFilter.html) and [itk::BinaryGeneratorImageFilter](https://docs.itk.org/projects/doxygen/en/stable/classitk_1_1BinaryGeneratorImageFilter.html)'s allow per-pixel operations to be specified in several ways: 1) traditional "Functor", with `operator()`, 2) C++11 lambda functions, with closures, 3) C++11 std::function 4) C-style function pointers.

7. New, experimental classes for C++11 iteration in [range-based for loops](https://en.cppreference.com/w/cpp/language/range-for), e.g. [itk::Experimental::ShapedImageNeighborhoodRange](https://docs.itk.org/projects/doxygen/en/stable/classitk_1_1Experimental_1_1ShapedImageNeighborhoodRange.html), provide a modern, convenient syntax for image pixel iteration, and dramatic performance improvements.

Furthmore, ITK 5 improves performance by leveraging [Rvalue references](http://thbecker.net/articles/rvalue_references/section_01.html) to implement move semantics and perfect forwarding.

![ITK 5 Performance Benchmarks](https://user-images.githubusercontent.com/25432/40628866-8fb6661c-6295-11e8-91f7-335cf24d9b7c.png)
**ITK 5 Performance Benchmark Improvements** *[ITK Performance Benchmarks](https://github.com/InsightSoftwareConsortium/ITKPerformanceBenchmarking), lower is better, for ITK 4.13.0, ITK 5.0 Alpha 2 with the platform thread pool, and ITK 5.0 Alpha 2 with TBB. ITK 5.0 advances performance in general, especially with the TBB threading backend.*

Thanks to everyone who contributed to the major advancements made in the ITK 5 performance refactoring. Special recognition goes to Dženan Zukić, Kitware, who lead the refactoring effort. Contributions were also made by Jared Vicory, Robert Maynard, Francois Budin, Matt McCormick, ￼Pablo Hernandez-Cerdan, Kitware, Jonathan Lefman, formerly of Intel, Bradley Lowekamp, associated with the National Library of Medicine, Hans Johnson, the University of Iowa, Simon Warfield, Benoit Scherrer, Rene-Paul Debroize, Amir Jaberzadeh, and Etienne St-Onge, Boston's Children's Hospital. The TBB-refactoring was inspired by the [TBBImageToImageFilter](https://github.com/InsightSoftwareConsortium/ITKTBBImageToImageFilter), which was supported in part by the Intel Parallel Computing Center at the Computational Radiology Laboratory, Boston Children's Hospital. Bradley Lowekamp contributed the *itk::UnaryGeneratorImageFilter* and *itk::BinaryGeneratorImageFilter* filters. Neils Dekker, Leiden University Medical Center, contributed the new range classes.

There were many other improvements and bug fixes since 5.0 Alpha 1. For example, addition of [.editorconfig](https://github.com/InsightSoftwareConsortium/ITK/blob/master/.editorconfig), prominent placement of [.clang-format](https://github.com/InsightSoftwareConsortium/ITK/blob/master/.clang-format), addition of ITK-specific debug [visualizers](https://github.com/InsightSoftwareConsortium/ITK/tree/master/Utilities/Debugger) for Visual Studio versions 2012-2017  improve editing and debugging experience in Visual Studio.

To test the ITK 5.0 Alpha 2 Python packages, run

```bash
python -m pip install --upgrade pip
python -m pip install --upgrade --pre itk
```

Note: there are a few warnings that appear when using the wrapping. These will be addressed with the next release.

The next planned release, ITK 5.0 RC1, will focus on the transition of code review process to GitHub.

```
Changes from v5.0 Alpha 1 to v5.0 Alpha 2
-----------------------------------------------------------

Bradley Lowekamp (22):
      PERF: remove virtual methods in neighborhood iterators
      ENH: Add ITK_ITERATOR_FINAL
      ENH: Use named inputs for the PasteImageFilter
      PERF: Remove iterators stored as member variables
      BUG: Add specification of OutputImage Type for TobogganImageFilter
      BUG: Add specification of OutputImage Type for TobogganImageFilter
      ENH: Improve numerics of resampling for linear transform
      COMP: Fix gcc 4.8 initialize warning
      ENH: Add baseline image to sporadically failing test
      ENH: Adding Unary and Binary GeneratorImageFilter
      ENH: Convert functor based filters to generator
      ENH: Update internal filters to use BinaryGereratorImageFilter
      ENH: Updating Functor filter with parameters to the new Generator
      COMP: Address Generator filters destructors warning
      DOC: Fix BSplineDecompositionImageFilter Doxygen see also link
      ENH: reuse default splitter
      BUG: revert thread update to BSplineScatteredDataPointSetToImageFilter
      ENH: Update CircleCI CMake version to 3.11.2
      BUG: Correct detection of most recent data file
      ENH: Improve numeric computation of linear interpolation for Resample
      ENH: Update baseline image for ResampleImageFilter3Test1
      BUG: Add 4 pixel tolerance to ResampleImageFilter3Test1

Dženan Zukić (37):
      ENH: start migration guide document
      STYLE: increasing initial size of the debug window
      BUG: fixing null pointer dereference at the end of iteration
      COMP: reducing direct usage of MultiThreader
      BUG: remove observations in FilterWatcher's destructor
      ENH: support Unicode characters in class documentation
      BUG: fixing index computation in resample filter
      ENH: reducing code duplication in FilterWatcher
      ENH: refactoring MultiThreader infrastructure
      ENH: deciding which filters can use the new threading model
      ENH: reporting progress
      ENH: simplifying Canny filter by using new threading infrastructure
      STYLE: Renaming MultiThreader to PlatformMultiThreader
      ENH: use C++11 thread primitives instead of SpawnThread
      COMP: improve backwards compatibility by retaining the renamed header
      ENH: Add TBB-based multi-threader
      ENH: refactoring filters to avoid use of memory barrier
      ENH: reworking logic for determining default multi-threader
      COMP: fixing compile error on GCC 4.8.5 20150623 (Red Hat 4.8.5-28)
      STYLE: remove outdated and useless comments from VectorExpandImageFilter
      ENH: add a baseline for QuickViewTest.png (Win7x64+VS2017+VTK8.1OpenGL2)
      STYLE: reduce number of lines by removing unnecessary empty lines
      DOC: document FilterWatcher removal
      ENH: adding an .editorconfig file to aid IDE's code formatting options
      BUG: forgotten #ifdefs for ITK_LEGACY_REMOVE
      ENH: adding debugger help files for Visual Studio 2017
      ENH: moving .clang-format file into the root folder,
      ENH: using the new threading mechanism for FFT module
      ENH: explicitly setting threading model in each multi-threaded filter
      ENH: support classic ThreadedGenerateData via ITK_CLASSIC_THREADING_MODEL
      BUG: fixing a test which has been failing since multi-threading refactoring
      ENH: updating baselines for itkBSplineScatteredDataPointSetToImageFilterTest*
      COMP: fixing 2 compile warnings
      STYLE: renaming migration guide document
      ENH: extending migration guide with threading refactoring instructions
      ENH: reducing redundancy in itkLandmarkBasedTransformInitializerTest
      ENH: eliminate CMake option ITK_CLASSIC_THREADING_MODEL

Hans Johnson (5):
      STYLE: Use C++11 override keyword directly
      STYLE: Use C++11 override keyword directly
      ENH: Add compression option for Transform files
      COMP: Address type mis-match compiler warning
      COMP: Remove unused variable warning

Jon Haitz Legarreta Gorroño (10):
      COMP: Use and move ITK_DISALLOW_COPY_AND_ASSIGN calls to public section.
      ENH: Update the WikiExamples remote module commit hash.
      COMP: Bump the remote modules' versions.
      DOC: Fix miscellaneous typos.
      DOC: Update the ITK logo files in `Documentation` folder.
      DOC: Remove PSD files containing old ITK logo.
      BUG: Address use of CMake variables in CMakeLists.txt.
      COMP: Set the minimum required CMake version to 3.10.2.
      STYLE: Stick to the ITK style guidelines.
      COMP: Bump the remote modules' versions after the CMake ver update.

Lucas Gandel (2):
      ENH: include WrapITKConfig for external module
      ENH: Allow for itk::ImageSource wrapping override

Matthew McCormick (17):
      ENH: Support Python snake case keyword arguments in object initializion
      PERF: Avoid extra condition check in itkBase.py
      COMP: Detect Linux in itkMemoryUsageObserver.h on Alpine Linux
      COMP: Define ITK_DELETE_FUNCTION for backwards compatibility
      BUG: Fix bugs in ITKV4_COMPATIBILITY definition
      COMP: Wrap MultiResolutionPDEDeformableRegistration for Pyramid filter types
      COMP: Do not disallow constructors in Python classes
      DOC: Add Mathieu Malaterre to GDCM copyright holders in NOTICE
      COMP: Address array initialization in itkShapedImageNeighborhoodRangeGTest
      COMP: ShapeImageNeighborhoodRange signed unsigned comparison
      COMP: Add missing itkViewImage.h include to itkViewImage.hxx
      COMP: Initialize CovariantVector in DeformableSimplexMesh3DFilter
      COMP: Update Unary and Binary filters for new generator class base
      COMP: Initialize DeformableSimpleMesh3DFilter displacement
      COMP: Suppress maybe-uninitialized in SimpleDataObjectDecorator Component
      COMP: Do not include itkMultiThreader.h in the header tests
      COMP: Fix Python wrapping of MultiThreaderBase

Niels Dekker (11):
      ENH: Added Compute member functions to NeighborhoodInnerProduct
      STYLE: Added DISALLOW_COPY_AND_ASSIGN(GaussianDerivativeImageFunction), etc.
      ENH: Added ShapedImageNeighborhoodRange for modern C++ style iteration
      STYLE: Removed '&' from pixelPointer param of NeighborhoodAccessorFunctor::Set
      PERF: Removed virtual ~NeighborhoodAccessorFunctor() and made class final
      COMP: Fixed ShapedImageNeighborhoodRange doxygen + signed/unsigned warning
      BUG: Dropped OffsetTable assumptions from ShapedImageNeighborhoodRange
      PERF: Made HoughTransform2DCircles GaussianDerivative call non-virtual
      COMP: Workaround Clang range-loop-analysis warning NeigborhoodRange test
      ENH: Added class to create offsets for a hyperrectangular neighborhood shape
      ENH: Random access support for ShapedImageNeighborhoodRange iterators

Pablo Hernandez-Cerdan (4):
      ENH: Add stateless viewer ViewImage with Python wrap.
      DOC: Add docs to ViewImage.
      COMP: Fix catch by value warning in SpatialObject.
      COMP: Fix VNL to compile with gcc8.

Rashad Kanavath (1):
      COMP: fix linking on OpenBSD

Sean McBride (4):
      COMP: -Wunused-template & -Winconsistent-missing-destructor-override warnings
      BUG: removed illegal int to enum conversion
      COMP: fix warning about implicit double to bool conversion
      COMP: fix warning about implicit double to bool conversion

Simon Rit (1):
      COMP: missing include path for FFTW

Taylor Braun-Jones (1):
      COMP: Fix clang diagnostic: case value cannot be narrowed

VXL Maintainers (1):
      VNL 2018-05-16 (26628604)
```

Enjoy ITK!
