"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Variants = exports.GlyphConstruction = exports.GlyphAssembly = exports.GlyphPart = exports.GlyphPartFlags = exports.GlyphVariantRecord = exports.Kern = exports.KernInfo = exports.GlyphInfo = exports.Constants = exports.Table = exports.Tag = void 0;
exports.Tag = "MATH";
class Table {
    constructor(constants = null, glyphInfo = null, variants = null) {
        this.constants = constants;
        this.glyphInfo = glyphInfo;
        this.variants = variants;
    }
}
exports.Table = Table;
class Constants {
    constructor() {
        this.scriptPercentScaleDown = 0;
        this.scriptScriptPercentScaleDown = 0;
        this.delimitedSubFormulaMinHeight = 0;
        this.displayOperatorMinHeight = 0;
        this.mathLeading = { value: 0 };
        this.axisHeight = { value: 0 };
        this.accentBaseHeight = { value: 0 };
        this.flattenedAccentBaseHeight = { value: 0 };
        this.subscriptShiftDown = { value: 0 };
        this.subscriptTopMax = { value: 0 };
        this.subscriptBaselineDropMin = { value: 0 };
        this.superscriptShiftUp = { value: 0 };
        this.superscriptShiftUpCramped = { value: 0 };
        this.superscriptBottomMin = { value: 0 };
        this.superscriptBaselineDropMax = { value: 0 };
        this.subSuperscriptGapMin = { value: 0 };
        this.superscriptBottomMaxWithSubscript = { value: 0 };
        this.spaceAfterScript = { value: 0 };
        this.upperLimitGapMin = { value: 0 };
        this.upperLimitBaselineRiseMin = { value: 0 };
        this.lowerLimitGapMin = { value: 0 };
        this.lowerLimitBaselineDropMin = { value: 0 };
        this.stackTopShiftUp = { value: 0 };
        this.stackTopDisplayStyleShiftUp = { value: 0 };
        this.stackBottomShiftDown = { value: 0 };
        this.stackBottomDisplayStyleShiftDown = { value: 0 };
        this.stackGapMin = { value: 0 };
        this.stackDisplayStyleGapMin = { value: 0 };
        this.stretchStackTopShiftUp = { value: 0 };
        this.stretchStackBottomShiftDown = { value: 0 };
        this.stretchStackGapAboveMin = { value: 0 };
        this.stretchStackGapBelowMin = { value: 0 };
        this.fractionNumeratorShiftUp = { value: 0 };
        this.fractionNumeratorDisplayStyleShiftUp = { value: 0 };
        this.fractionDenominatorShiftDown = { value: 0 };
        this.fractionDenominatorDisplayStyleShiftDown = { value: 0 };
        this.fractionNumeratorGapMin = { value: 0 };
        this.fractionNumDisplayStyleGapMin = { value: 0 };
        this.fractionRuleThickness = { value: 0 };
        this.fractionDenominatorGapMin = { value: 0 };
        this.fractionDenomDisplayStyleGapMin = { value: 0 };
        this.skewedFractionHorizontalGap = { value: 0 };
        this.skewedFractionVerticalGap = { value: 0 };
        this.overbarVerticalGap = { value: 0 };
        this.overbarRuleThickness = { value: 0 };
        this.overbarExtraAscender = { value: 0 };
        this.underbarVerticalGap = { value: 0 };
        this.underbarRuleThickness = { value: 0 };
        this.underbarExtraDescender = { value: 0 };
        this.radicalVerticalGap = { value: 0 };
        this.radicalDisplayStyleVerticalGap = { value: 0 };
        this.radicalRuleThickness = { value: 0 };
        this.radicalExtraAscender = { value: 0 };
        this.radicalKernBeforeDegree = { value: 0 };
        this.radicalKernAfterDegree = { value: 0 };
        this.radicalDegreeBottomRaisePercent = 0;
    }
}
exports.Constants = Constants;
class GlyphInfo {
    constructor(italicCorrections = new Map(), topAccentAttachments = new Map(), extendedShapes = null, kernInfos = new Map()) {
        this.italicCorrections = italicCorrections;
        this.topAccentAttachments = topAccentAttachments;
        this.extendedShapes = extendedShapes;
        this.kernInfos = kernInfos;
    }
}
exports.GlyphInfo = GlyphInfo;
class KernInfo {
    constructor(topRight = null, topLeft = null, bottomRight = null, bottomLeft = null) {
        this.topRight = topRight;
        this.topLeft = topLeft;
        this.bottomRight = bottomRight;
        this.bottomLeft = bottomLeft;
    }
}
exports.KernInfo = KernInfo;
class Kern {
    constructor(kernValue = { value: 0 }, corrections = []) {
        this.kernValue = kernValue;
        this.corrections = corrections;
    }
}
exports.Kern = Kern;
class GlyphVariantRecord {
    constructor(variantGlyph, advanceMeasurement) {
        this.variantGlyph = variantGlyph;
        this.advanceMeasurement = advanceMeasurement;
    }
}
exports.GlyphVariantRecord = GlyphVariantRecord;
var GlyphPartFlags;
(function (GlyphPartFlags) {
    GlyphPartFlags[GlyphPartFlags["Extender"] = 1] = "Extender";
})(GlyphPartFlags = exports.GlyphPartFlags || (exports.GlyphPartFlags = {}));
class GlyphPart {
    constructor(partGlyph, startConnectorLength, endConnectorLength, fullAdvance, flags) {
        this.partGlyph = partGlyph;
        this.startConnectorLength = startConnectorLength;
        this.endConnectorLength = endConnectorLength;
        this.fullAdvance = fullAdvance;
        this.flags = flags;
    }
}
exports.GlyphPart = GlyphPart;
class GlyphAssembly {
    constructor(italicCorrection, parts) {
        this.italicCorrection = italicCorrection;
        this.parts = parts;
    }
}
exports.GlyphAssembly = GlyphAssembly;
class GlyphConstruction {
    constructor(assembly = null, variants = []) {
        this.assembly = assembly;
        this.variants = variants;
    }
}
exports.GlyphConstruction = GlyphConstruction;
class Variants {
    constructor(minConnectorOverlap = 0, vertical = new Map(), horizontal = new Map()) {
        this.minConnectorOverlap = minConnectorOverlap;
        this.vertical = vertical;
        this.horizontal = horizontal;
    }
}
exports.Variants = Variants;
//# sourceMappingURL=index.js.map