/// <reference types="node" />
import { Data } from "@ot-builder/prelude";
import { OtVar } from "@ot-builder/variance";
import { OtGlyph } from "../../ot-glyph";
export declare const Tag1 = "CFF ";
export declare const Tag2 = "CFF2";
export declare class PrivateDict {
    blueValues: OtVar.Value[];
    otherBlues: OtVar.Value[];
    familyBlues: OtVar.Value[];
    familyOtherBlues: OtVar.Value[];
    stemSnapH: OtVar.Value[];
    stemSnapV: OtVar.Value[];
    blueScale: OtVar.Value;
    blueShift: OtVar.Value;
    blueFuzz: OtVar.Value;
    stdHW: OtVar.Value;
    stdVW: OtVar.Value;
    languageGroup: number;
    expansionFactor: OtVar.Value;
    defaultWidthX: number;
    nominalWidthX: number;
    forceBold: boolean;
    initialRandomSeed: number;
    localSubroutines: Buffer[] | null;
    inheritedVsIndex: number;
}
export declare class CID {
    registry: string;
    ordering: string;
    supplement: number;
    mapping: Data.Maybe<Map<number, OtGlyph>>;
}
export declare class FontDict {
    version: Data.Maybe<string>;
    notice: Data.Maybe<string>;
    copyright: Data.Maybe<string>;
    fullName: Data.Maybe<string>;
    familyName: Data.Maybe<string>;
    weight: Data.Maybe<string>;
    isFixedPitch: boolean;
    italicAngle: number;
    underlinePosition: number;
    underlineThickness: number;
    paintType: number;
    readonly charStringType: number;
    strokeWidth: number;
    privateDict: Data.Maybe<PrivateDict>;
    fontMatrix: Data.Maybe<OtGlyph.Transform2X3>;
    cidFontName: Data.Maybe<string>;
    cidFontVersion: number;
    cidFontRevision: number;
    cidFontType: number;
    cidCount: number;
}
export declare class Table {
    readonly version: number;
    constructor(version: number);
    postScriptFontName: string;
    cid: Data.Maybe<CID>;
    topDict: FontDict;
    fdArray: Data.Maybe<FontDict[]>;
    fdSelect: Data.Maybe<Map<OtGlyph, number>>;
}
//# sourceMappingURL=table.d.ts.map