add_task(async function () {
  const url =
    "data:text/html," +
    "<html onmousemove='event.stopPropagation()'" +
    " onmouseenter='event.stopPropagation()' onmouseleave='event.stopPropagation()'" +
    " onmouseover='event.stopPropagation()' onmouseout='event.stopPropagation()'>" +
    '<p id="p1" title="tooltip is here">This paragraph has a tooltip.</p>' +
    '<p id="p2">This paragraph doesn\'t have tooltip.</p></html>';

  let tab = await BrowserTestUtils.openNewForegroundTab(gBrowser, url);
  let browser = gBrowser.selectedBrowser;

  await SpecialPowers.pushPrefEnv({ set: [["ui.tooltip.delay_ms", 0]] });

  let popupShownPromise = BrowserTestUtils.waitForEvent(
    document,
    "popupshown",
    false,
    event => {
      is(event.originalTarget.localName, "tooltip", "tooltip is showing");
      return true;
    }
  );
  let popupHiddenPromise = BrowserTestUtils.waitForEvent(
    document,
    "popuphidden",
    false,
    event => {
      is(event.originalTarget.localName, "tooltip", "tooltip is hidden");
      return true;
    }
  );

  // Send a mousemove at a known position to start the test.
  await BrowserTestUtils.synthesizeMouseAtCenter(
    "#p2",
    { type: "mousemove" },
    browser
  );
  await BrowserTestUtils.synthesizeMouseAtCenter(
    "#p1",
    { type: "mousemove" },
    browser
  );
  await popupShownPromise;
  await BrowserTestUtils.synthesizeMouseAtCenter(
    "#p2",
    { type: "mousemove" },
    browser
  );
  await popupHiddenPromise;

  gBrowser.removeCurrentTab();
});
