/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2025 Univ. Grenoble Alpes, CNRS, Grenoble INP - UGA, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
#ifndef ITKTEMPLATES_IMAGEBUFFERRANGE_H
#define ITKTEMPLATES_IMAGEBUFFERRANGE_H

#include <ItkTemplatesAPI.h>
#include <itkImageBufferRange.h>
#include <itkImage.h>

extern template class ITKTEMPLATES_API itk::ImageBufferRange<itk::Image<char, 2u> >;
extern template class ITKTEMPLATES_API itk::ImageBufferRange<itk::Image<char, 3u> >;
extern template class ITKTEMPLATES_API itk::ImageBufferRange<itk::Image<double, 2u> >;
extern template class ITKTEMPLATES_API itk::ImageBufferRange<itk::Image<double, 3u> >;
extern template class ITKTEMPLATES_API itk::ImageBufferRange<itk::Image<float, 2u> >;
extern template class ITKTEMPLATES_API itk::ImageBufferRange<itk::Image<float, 3u> >;
extern template class ITKTEMPLATES_API itk::ImageBufferRange<itk::Image<int, 2u> >;
extern template class ITKTEMPLATES_API itk::ImageBufferRange<itk::Image<int, 3u> >;
extern template class ITKTEMPLATES_API itk::ImageBufferRange<itk::Image<long, 2u> >;
extern template class ITKTEMPLATES_API itk::ImageBufferRange<itk::Image<long, 3u> >;
extern template class ITKTEMPLATES_API itk::ImageBufferRange<itk::Image<short, 2u> >;
extern template class ITKTEMPLATES_API itk::ImageBufferRange<itk::Image<short, 3u> >;
extern template class ITKTEMPLATES_API itk::ImageBufferRange<itk::Image<signed char, 2u> >;
extern template class ITKTEMPLATES_API itk::ImageBufferRange<itk::Image<signed char, 3u> >;
extern template class ITKTEMPLATES_API itk::ImageBufferRange<itk::Image<unsigned char, 2u> >;
extern template class ITKTEMPLATES_API itk::ImageBufferRange<itk::Image<unsigned char, 3u> >;
extern template class ITKTEMPLATES_API itk::ImageBufferRange<itk::Image<unsigned int, 2u> >;
extern template class ITKTEMPLATES_API itk::ImageBufferRange<itk::Image<unsigned int, 3u> >;
extern template class ITKTEMPLATES_API itk::ImageBufferRange<itk::Image<unsigned long, 2u> >;
extern template class ITKTEMPLATES_API itk::ImageBufferRange<itk::Image<unsigned long, 3u> >;
extern template class ITKTEMPLATES_API itk::ImageBufferRange<itk::Image<unsigned short, 2u> >;
extern template class ITKTEMPLATES_API itk::ImageBufferRange<itk::Image<unsigned short, 3u> >;

#include <itkBufferedImageNeighborhoodPixelAccessPolicy.h>

extern template class ITKTEMPLATES_API itk::BufferedImageNeighborhoodPixelAccessPolicy<itk::Image<char, 2u>>;
extern template class ITKTEMPLATES_API itk::BufferedImageNeighborhoodPixelAccessPolicy<itk::Image<char, 3u>>;
extern template class ITKTEMPLATES_API itk::BufferedImageNeighborhoodPixelAccessPolicy<itk::Image<double, 2u>>;
extern template class ITKTEMPLATES_API itk::BufferedImageNeighborhoodPixelAccessPolicy<itk::Image<double, 3u>>;
extern template class ITKTEMPLATES_API itk::BufferedImageNeighborhoodPixelAccessPolicy<itk::Image<float, 2u>>;
extern template class ITKTEMPLATES_API itk::BufferedImageNeighborhoodPixelAccessPolicy<itk::Image<float, 3u>>;
extern template class ITKTEMPLATES_API itk::BufferedImageNeighborhoodPixelAccessPolicy<itk::Image<int, 2u>>;
extern template class ITKTEMPLATES_API itk::BufferedImageNeighborhoodPixelAccessPolicy<itk::Image<int, 3u>>;
extern template class ITKTEMPLATES_API itk::BufferedImageNeighborhoodPixelAccessPolicy<itk::Image<long, 2u>>;
extern template class ITKTEMPLATES_API itk::BufferedImageNeighborhoodPixelAccessPolicy<itk::Image<long, 3u>>;
extern template class ITKTEMPLATES_API itk::BufferedImageNeighborhoodPixelAccessPolicy<itk::Image<short, 2u>>;
extern template class ITKTEMPLATES_API itk::BufferedImageNeighborhoodPixelAccessPolicy<itk::Image<short, 3u>>;
extern template class ITKTEMPLATES_API itk::BufferedImageNeighborhoodPixelAccessPolicy<itk::Image<signed char, 2u>>;
extern template class ITKTEMPLATES_API itk::BufferedImageNeighborhoodPixelAccessPolicy<itk::Image<signed char, 3u>>;
extern template class ITKTEMPLATES_API itk::BufferedImageNeighborhoodPixelAccessPolicy<itk::Image<unsigned char, 2u>>;
extern template class ITKTEMPLATES_API itk::BufferedImageNeighborhoodPixelAccessPolicy<itk::Image<unsigned char, 3u>>;
extern template class ITKTEMPLATES_API itk::BufferedImageNeighborhoodPixelAccessPolicy<itk::Image<unsigned int, 2u>>;
extern template class ITKTEMPLATES_API itk::BufferedImageNeighborhoodPixelAccessPolicy<itk::Image<unsigned int, 3u>>;
extern template class ITKTEMPLATES_API itk::BufferedImageNeighborhoodPixelAccessPolicy<itk::Image<unsigned long, 2u>>;
extern template class ITKTEMPLATES_API itk::BufferedImageNeighborhoodPixelAccessPolicy<itk::Image<unsigned long, 3u>>;
extern template class ITKTEMPLATES_API itk::BufferedImageNeighborhoodPixelAccessPolicy<itk::Image<unsigned short, 2u>>;
extern template class ITKTEMPLATES_API itk::BufferedImageNeighborhoodPixelAccessPolicy<itk::Image<unsigned short, 3u>>;

#endif // ITKTEMPLATES_IMAGEBUFFERRANGE_H